<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Response;
use App\Resps\Interfaces\Upload;

class UploadController extends Controller
{
    protected $upload;

    public function __construct(Upload $upload)
    {
        $this->upload = $upload;
    }

    public function index()
    {
        $base64 = trim(request()->get('image'));
        if (!$base64 || !$position = strpos($base64, ',')) {
            return Response::error(['code' => 401]);
        }
        $params = [
            'name'=>trim(request()->get('name')),
            'base64_code'=>$base64
        ];
        return Response::auto($this->upload->base64upload($params));
    }
}
