<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Resps\Interfaces\News as NewsInterface;

class NewsApiController extends Controller
{
    protected $news;

    public function __construct(NewsInterface $news)
    {
        $this->news = $news;
    }

    public function index()
    {
        $fillables = [
            'page',
            'title',
            'keyword',
            'sort_id'
        ];
        $params = request()->only($fillables);
        return $this->news->index($params);
    }
    public function show($id)
    {
        return $this->news->show($id);
    }
}
