<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateNewsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('news', function (Blueprint $table) {
            $table->increments('id')->unsigned();
            $table->string('title',50);
            $table->string('keyword', 100);
            $table->string('abstract', 100);
            $table->integer('sort_id');
            $table->string('index_image',255)->nullable();
            $table->text('content');
            $table->tinyInteger('status')->default(1)->comment('1:待发布,2:已发布');
            $table->integer('creator_id');
            $table->integer('mender_id');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('news');
    }
}
