new (class newsFormApp extends AdminBase {
    constructor() {
        super();
        this.id = id;
        this.init();
    }

    init() {
        // 索引图上传
        let _this = this;
        new Vue({
            el: '#news_form_app',
            data: {
                sort_span: {
                    html: '',
                    show: false
                },
                form_data: {
                    title: '',
                    keyword: '',
                    abstract: '',
                    sort_id: 1,
                    index_image: '',
                },
                index_image: {
                    is_upload: false,
                    title: '点击添加',
                    html: '<i class="fa fa-plus"></i>',
                    style: {lineHeight: '6rem'},
                    url: '',
                },
            },
            mounted: function () {
                DecoupledEditor
                    .create(document.querySelector('#editor-container'), {
                        language: 'zh-cn'
                    })
                    .then(editor => {
                        const toolbarContainer = document.querySelector('#toolbar-container');
                        toolbarContainer.appendChild(editor.ui.view.toolbar.element);
                        editor.plugins.get('FileRepository').createUploadAdapter = function (loader) {
                            return new CkuploadAdapter(loader);
                        };
                        _this.editor = editor;
                    })
                    .catch(error => {
                        console.error(error);
                    });
                //更新操作
                if (_this.id) {
                    $.getJSON(`/news/news/${_this.id}`, (data) => {
                        if (data.code !== 0 || !data.data) {
                            return AdminBase.danger(data.msg || '操作异常', () => {
                                location.href = '/news/news'
                            }, 1000);
                        }
                        let detail = data.data;
                        this.form_data.title = detail.title;
                        this.form_data.keyword = detail.keyword;
                        this.form_data.abstract = detail.abstract;
                        this.form_data.sort_id = 1;
                        this.form_data.index_image = detail.index_image;
                        if (this.form_data.index_image) {
                            this.index_image.is_upload = true;
                            this.index_image.title = '点击修改';
                            this.index_image.html = `<div class="index_image_wrap"><i class="fa fa-times-circle" title="删除"></i><img src="${this.form_data.index_image}"></div>`;
                            this.index_image.style = {lineHeight: 'normal'};
                        }
                        _this.editor.setData(detail.content);
                    });
                }
            },
            methods: {
                triggerFile: function (event) {
                    let file = document.querySelector('input[name=index_image]');
                    if (!this.index_image.is_upload) {
                        file.click();
                    }
                    if (this.index_image.is_upload && event.target.tagName === 'I') {
                        //todo 选择上次图片bug，删除服务器图片
                        this.form_data.index_image = '';
                        this.index_image.title = '点击添加';
                        this.index_image.html = '<i class="fa fa-plus"></i>';
                        this.index_image.style = {lineHeight: '6rem'};
                        this.index_image.is_upload = false;
                    }
                },
                handleImage: function (event) {
                    let input = event.currentTarget,
                        file = input.files[0],
                        _this = this;
                    new Promise((resolve, reject) => {
                        new Upload(file, resolve, reject);
                    }).then(function (a) {
                        _this.form_data.index_image = a.default;
                        _this.index_image.is_upload = true;
                        _this.index_image.title = '点击修改';
                        _this.index_image.html = `<div class="index_image_wrap"><i class="fa fa-times-circle" title="删除"></i><img src="${a.default}"></div>`;
                        _this.index_image.style = {lineHeight: 'normal'};
                    }).catch(
                        //todo upload failed suggestion
                    );
                },
                formSub: function () {
                    let type = `${_this.id ? 'PUT' : 'POST'}`,
                        prefix = _this.id ? '修改' : '创建';
                    this.form_data.content = _this.editor.getData();
                    $.ajax({
                        url: `/news/news${_this.id ? '/' + _this.id : ''}`,
                        type: type,
                        data: this.form_data,
                        headers: {'X-CSRF-TOKEN': AdminBase.csrf_token()},
                        success: (data) => {
                            return data.code === 0 ? AdminBase.success(`${prefix}成功`, () => {
                                location.href = '/news/news'
                            }, 1000) : AdminBase.fail(data.msg || `${prefix}失败`);
                        }
                    });
                }
            }
        });

    }
});