@extends('admin.index')
@section('head')
    @parent
    <link href="/static/css/news/news_form.css?vt={{time()}}" type="text/css" rel="stylesheet">
@endsection
@section('main-content')
    <section class="content animated slideInRight">
        <div class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    {{--<div class="col-sm-12">--}}
                    {{--<ol class="breadcrumb float-sm-left">--}}
                    {{--<li class="breadcrumb-item"><a href="/net/net">设置</a></li>--}}
                    {{--</ol>--}}
                    {{--</div>--}}
                </div>
            </div>
        </div>
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <form id="news_form_app">
                        <ul class="timeline timeline-inverse" id="news_form_ul">
                            <li class="time-label">
                                <span>网站标题</span>
                            </li>
                            <li>
                                <div class="timeline-item">
                                    <input type="text" class="form-control" v-model="form_data.title">
                                </div>
                            </li>
                            <li class="time-label">
                                <span>关键字</span>
                            </li>
                            <li>
                                <div class="timeline-item">
                                    <input type="text" class="form-control" v-model="form_data.keywords">
                                    <span class="form_check_span grey">* 多个逗号隔开</span>
                                </div>
                            </li>
                            <li class="time-label">
                                <span>描述</span>
                            </li>
                            <li>
                                <div class="timeline-item">
                                    <textarea class="form-control" v-model="form_data.description"></textarea>
                                </div>
                            </li>
                            <li class="time-label">
                                <span>广告</span>
                            </li>
                            <li>
                                <div class="timeline-item">
                                    <input type="checkbox" id="ids_1" class="chk" v-model="form_data.open_bd">
                                    <label for="ids_1">开启广告</label>
                                    <hr/>
                                    <div class="timeline-body">
                                        <span style="font-weight: 300 !important;">广告图片</span>
                                        <span class="news-form-index" :title="index_image.title"
                                              @click="triggerFile($event)"
                                              :style="index_image.style"
                                              v-html="index_image.html"></span>
                                        <input type="file" name="index_image" style="display:none"
                                               @change="handleImage($event)">
                                        <span class="form_check_span orange">* 选填</span>
                                        <hr/>
                                        <span style="font-weight: 300 !important;">广告链接</span>
                                        <input type="text" class="form-control" name="link" v-model="form_data.bd_link">
                                        <span class="form_check_span orange">* 需完整的http://或https://开头</span>
                                    </div>
                                </div>
                            </li>
                            <li class="time-label">
                                <span>页脚</span>
                            </li>
                            <li>
                                <div class="timeline-item">
                                    <input type="checkbox" id="ids_2" class="chk" v-model="form_data.open_foot">
                                    <label for="ids_2">开启页脚替换</label>
                                    <hr/>
                                    <div class="timeline-body">
                                        <span style="font-weight: 300 !important;">版权</span>
                                        <input type="text" class="form-control" name="link" v-model="form_data.banquan">
                                        <span class="form_check_span orange">* 选填</span>
                                        <hr/>
                                        <span style="font-weight: 300 !important;">备案</span>
                                        <input type="text" class="form-control" name="link" v-model="form_data.beian">
                                        <span class="form_check_span orange">* 选填</span>
                                        <hr/>
                                        <span style="font-weight: 300 !important;">友情链接名称(多个@号隔开)</span>
                                        <input type="text" class="form-control" name="link" v-model="form_data.lianjie_name">
                                        <span style="font-weight: 300 !important;">友情链接(多个@号隔开)</span>
                                        <input type="text" class="form-control" name="link" v-model="form_data.lianjie">
                                        <span class="form_check_span orange">* 链接名称和链接数量必须相同且左右次序一一对应</span><br/>
                                        <span class="form_check_span orange">* 需完整的http://或https://开头</span><br/>
                                    </div>
                                </div>
                            </li>
                            <li class="time-label">
                                <span class="news_sub cp" @click="formSub">生成发布</span>
                            </li>
                        </ul>
                    </form>
                </div>
            </div>
        </div>
    </section>
@section('script')
    @parent
    <script src="/static/js/upload.js?vt={{time()}}"></script>
    <script src="/static/js/ckuploadAdapter.js?vt={{time()}}"></script>
    <script src="/static/js/net/net.js?vt={{time()}}"></script>
@endsection
@endsection